#ifndef GTS_BUILD_LAZY_BLOCK_C
#define GTS_BUILD_LAZY_BLOCK_C

	.align	4
	.data
next_build_lazy_block_id:
	.long	0
lazy_block_id_found:
	.long	0
searched_dynamic_id:
	.long	0
	
	.align	4
	.text
init_lazy_block_id:
	movl	$0,next_build_lazy_block_id
	ret
	
#define INVALID_DYNAMIC_ID	0xffffffff
	
// Input:
// - %ebx = dynamic ID, generated by dynamic linker
// Output:
// - %ebx = build lazy block id
//
convert_dynamic_id_into_build_lazy_block_id:
	movl	%ebx,searched_dynamic_id
	
	// Search if the conversion has already been done by looking for the dynamic ID
	movl	$0,lazy_block_id_found
	movl	$ has_conversion_already_been_done,%ecx
	call 	MAKE_ID_FDS(lb_map_array)
	
	movl	lazy_block_id_found,%ebx
	cmpl	$0,%ebx
	je		generate_new_lazy_id

	movl	LDR_LAZY_DYNAMIC_INDEX(%ebx),%ebx
	ret
	
generate_new_lazy_id:
	movl	next_build_lazy_block_id,%ebx
	incl	next_build_lazy_block_id
	ret
	
has_conversion_already_been_done:
#define ldr %ecx
#define temp %eax
	// determine whether the current LDR_ID is the searched dynamic ID
	movl	LDR_ID(ldr),temp
	cmpl	temp,searched_dynamic_id
	jne		has_conversion_already_been_done__end
	
	movl	%ecx,lazy_block_id_found
	
#undef temp
#undef ldr
has_conversion_already_been_done__end:
	ret

#endif